import 'dart:developer' as dev;

import 'package:photogram_admin_cp/config.dart';
import 'package:photogram_admin_cp/import/core.dart';

class AppLogger {
  static void exception(Object e) {
    print(e);
    info(e);
  }

  static void info(message, {String? error, AppLogType logType = AppLogType.other}) {
    if (!APP_CLIENT_DEBUG) return;

    dev.log(message.toString());

    if (null != error) {
      dev.log(error);
    }
  }

  static void high(message) => AppLogger.info(message, logType: AppLogType.highPriorityDebug);

  static void blockInfo(message) => AppLogger.info(message, logType: AppLogType.bloc);

  static void navigationInfo(message) => AppLogger.info(message, logType: AppLogType.navigation);
}
